#include "ButtonToggle.h"

ButtonToggle::ButtonToggle(int pin, unsigned long debounceDelay)
  : buttonPin(pin), state(false), lastButtonState(LOW),
    lastDebounceTime(0), debounceDelay(debounceDelay) {}

void ButtonToggle::begin() {
  pinMode(buttonPin, INPUT_PULLUP); // Ενεργοποίηση του pull-up αντιστάτη
}

bool ButtonToggle::toggleState() {
  int reading = digitalRead(buttonPin);

  if (reading != lastButtonState) {
    lastDebounceTime = millis(); // Ανανέωση του χρόνου για debounce
  }

  if ((millis() - lastDebounceTime) > debounceDelay) {
    if (reading == LOW && lastButtonState == HIGH) {
      state = !state; // Εναλλαγή κατάστασης
    }
  }

  lastButtonState = reading; // Ανανέωση της τελευταίας κατάστασης
  return state;
}
