#ifndef TDSCONCENTRATION_H
#define TDSCONCENTRATION_H

#include <GravityTDS.h>

class TDSConcentration {
  private:
    GravityTDS tdsSensor;
    float temperature;

    float ppmToWeightPercent(float ppm) {
      return ppm / 10000; // Μετατροπή σε %w/w
    }

  public:
    // Κατασκευαστής για την αρχικοποίηση της θύρας και της θερμοκρασίας
    TDSConcentration(int pin, float initTemperature = 25.0) : temperature(initTemperature) {
      tdsSensor.setPin(pin);          // Ορισμός της θύρας του TDS
      tdsSensor.setAref(5.0);          // Τάση αναφοράς
      tdsSensor.setAdcRange(1024);     // Εύρος ADC
    }

    void begin() {
      tdsSensor.begin(); // Αρχικοποίηση του αισθητήρα
    }

    void setTemperature(float temp) {
      temperature = temp; // Ορισμός θερμοκρασίας
      tdsSensor.setTemperature(temp); // Θερμοκρασιακή αντιστάθμιση
    }

    float readConcentration() {
      tdsSensor.update();                    // Ενημέρωση και υπολογισμός TDS
      float ppm = tdsSensor.getTdsValue();   // Ανάγνωση τιμής TDS σε ppm
      return ppmToWeightPercent(ppm);        // Μετατροπή σε %w/w και επιστροφή
    }
};

#endif
